#include <p30fxxxx.h>
#include <ports.h>

#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__)|| \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__)|| \
    defined(__dsPIC30F2012__) || defined(__dsPIC30F3013__) || defined(__dsPIC30F3014__)|| \
    defined(__dsPIC30F4013__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__)|| \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__)|| \
    defined(__dsPIC30F6014__) || defined(__dsPIC30F5015__)

/*******************************************************************
* Function Name     : ConfigINT2
* Description       : Enables external interrupt on pin INT2.
* Parameters        : config determines the interrupt edge, priority 
*                     and enable/disable information.
* Return Value      : None
********************************************************************/

void ConfigINT2(unsigned int config)
{
    IFS1bits.INT2IF = 0;                       /* clear the interrupt flag */
    IPC5bits.INT2IP = config & 0x07;           /* assign interrupt priority */

    INTCON2bits.INT2EP = (config & 0x10) >> 4; /* assign edge selected */

    IEC1bits.INT2IE = (config & 0x08) >> 3;    /* enable/disable interrupt */
}
/* end of function ConfigINT2 */

#endif
